## Door Tables ##

normal_offset_table = {
    0x01: 0x01, 0x02: 0x02, 0x04: 0x03, 0x06: 0x04, 0x0d: 0x05, 0x11: 0x06, 0x12: 0x07, 0x13: 0x08,
    0x14: 0x09, 0x15: 0x0A, 0x16: 0x0B, 0x19: 0x0C, 0x1a: 0x0D, 0x1b: 0x0E, 0x1d: 0x0F, 0x1e: 0x10,
    0x1f: 0x11, 0x20: 0x12, 0x21: 0x13, 0x22: 0x14, 0x23: 0x15, 0x24: 0x16, 0x26: 0x17, 0x2a: 0x18,
    0x2b: 0x19, 0x2e: 0x1A, 0x30: 0x1B, 0x32: 0x1C, 0x33: 0x1D, 0x34: 0x1E, 0x35: 0x1F, 0x36: 0x20,
    0x37: 0x21, 0x38: 0x22, 0x39: 0x23, 0x3a: 0x24, 0x3b: 0x25, 0x3d: 0x26, 0x3e: 0x27, 0x41: 0x28,
    0x43: 0x29, 0x44: 0x2A, 0x45: 0x2B, 0x46: 0x2C, 0x49: 0x2D, 0x4a: 0x2E, 0x4b: 0x2F, 0x4c: 0x30,
    0x4d: 0x31, 0x4e: 0x32, 0x50: 0x33, 0x51: 0x34, 0x52: 0x35, 0x53: 0x36, 0x56: 0x37, 0x57: 0x38,
    0x58: 0x39, 0x59: 0x3A, 0x5a: 0x3B, 0x5b: 0x3C, 0x5c: 0x3D, 0x5d: 0x3E, 0x5e: 0x3F, 0x5f: 0x40,
    0x60: 0x41, 0x61: 0x42, 0x62: 0x43, 0x66: 0x44, 0x67: 0x45, 0x68: 0x46, 0x6a: 0x47, 0x6b: 0x48,
    0x6c: 0x49, 0x6d: 0x4A, 0x6e: 0x4B, 0x71: 0x4C, 0x75: 0x4D, 0x76: 0x4E, 0x7b: 0x4F, 0x7c: 0x50,
    0x7d: 0x51, 0x7e: 0x52, 0x7f: 0x53, 0x81: 0x54, 0x85: 0x55, 0x8b: 0x56, 0x8c: 0x57, 0x8d: 0x58,
    0x8e: 0x59, 0x90: 0x5A, 0x91: 0x5B, 0x92: 0x5C, 0x93: 0x5D, 0x95: 0x5E, 0x96: 0x5F, 0x99: 0x60,
    0x9b: 0x61, 0x9c: 0x62, 0x9d: 0x63, 0x9e: 0x64, 0x9f: 0x65, 0xa0: 0x66, 0xa1: 0x67, 0xa2: 0x68,
    0xa3: 0x69, 0xa4: 0x6A, 0xa5: 0x6B, 0xa8: 0x6C, 0xa9: 0x6D, 0xaa: 0x6E, 0xab: 0x6F, 0xac: 0x70,
    0xae: 0x71, 0xaf: 0x72, 0xb1: 0x73, 0xb2: 0x74, 0xb3: 0x75, 0xb4: 0x76, 0xb5: 0x77, 0xb6: 0x78,
    0xb7: 0x79, 0xb8: 0x7A, 0xb9: 0x7B, 0xba: 0x7C, 0xbb: 0x7D, 0xbc: 0x7E, 0xbe: 0x7F, 0xbf: 0x80,
    0xc1: 0x81, 0xc2: 0x82, 0xc3: 0x83, 0xc4: 0x84, 0xc5: 0x85, 0xc6: 0x86, 0xc7: 0x87, 0xc8: 0x88,
    0xc9: 0x89, 0xcb: 0x8A, 0xcc: 0x8B, 0xce: 0x8C, 0xd1: 0x8D, 0xd2: 0x8E, 0xd5: 0x8F, 0xd6: 0x90,
    0xd8: 0x91, 0xd9: 0x92, 0xda: 0x93, 0xdb: 0x94, 0xdc: 0x95,
    0x40: 0x96, 0x42: 0x97,  # newcomers for str stairs
    # newcomers for entrances
    0x28: 0x98, 0x0e: 0x99, 0x0c: 0x9a, 0x98: 0x9b, 0x83: 0x9c, 0x84: 0x9d, 0x77: 0x9e, 0xe0: 0x9f,
    0x63: 0xa0
}


spiral_offset_table = {
    0x01: 0x01, 0x02: 0x02, 0x04: 0x03, 0x07: 0x04, 0x09: 0x05, 0x0a: 0x07, 0x0c: 0x08, 0x0e: 0x0b,
    0x11: 0x0c, 0x15: 0x0d, 0x16: 0x0e, 0x17: 0x0f, 0x1a: 0x11, 0x1c: 0x13, 0x1d: 0x14, 0x1e: 0x15,
    0x26: 0x16, 0x27: 0x19, 0x28: 0x1b, 0x31: 0x1c, 0x34: 0x1f, 0x38: 0x20, 0x3a: 0x21, 0x3f: 0x22,
    0x40: 0x23, 0x41: 0x24, 0x42: 0x25, 0x45: 0x26, 0x4a: 0x27, 0x4c: 0x29, 0x4d: 0x2a, 0x4e: 0x2b,
    0x53: 0x2c, 0x54: 0x2d, 0x5c: 0x2e, 0x5d: 0x2f, 0x5f: 0x30, 0x63: 0x35, 0x64: 0x36, 0x66: 0x37,
    0x6a: 0x38, 0x6b: 0x3a, 0x6c: 0x3b, 0x6e: 0x3c, 0x70: 0x3d, 0x71: 0x40, 0x72: 0x41, 0x76: 0x42,
    0x77: 0x45, 0x7f: 0x49, 0x80: 0x4a, 0x87: 0x4b, 0x8c: 0x4f, 0x8e: 0x53, 0x91: 0x54, 0x93: 0x55,
    0x97: 0x56, 0x98: 0x57, 0x99: 0x58, 0x9e: 0x59, 0xa0: 0x5a, 0xa2: 0x5b, 0xa5: 0x5c, 0xa6: 0x5d,
    0xab: 0x5e, 0xae: 0x5f, 0xb0: 0x60, 0xb5: 0x63, 0xb6: 0x64, 0xbc: 0x65, 0xbe: 0x66, 0xc0: 0x67,
    0xd0: 0x6a, 0xd1: 0x6d, 0xd2: 0x6e, 0xda: 0x6f, 0xe0: 0x70
}

door_pair_offset_table = {
    0x01: 0x0001, 0x02: 0x0003, 0x04: 0x0006, 0x06: 0x000b, 0x0a: 0x000c, 0x0b: 0x000d, 0x0c: 0x0010, 0x0d: 0x0011,
    0x0e: 0x0012, 0x11: 0x0015, 0x12: 0x0018, 0x13: 0x001c, 0x14: 0x001e, 0x15: 0x0025, 0x16: 0x0027, 0x19: 0x002b,
    0x1a: 0x002d, 0x1b: 0x0033, 0x1c: 0x0035, 0x1d: 0x0038, 0x1e: 0x0039, 0x1f: 0x003d, 0x20: 0x003f, 0x21: 0x0040,
    0x22: 0x0043, 0x23: 0x0045, 0x24: 0x0047, 0x26: 0x004f, 0x28: 0x0053, 0x2a: 0x0055, 0x2b: 0x005b, 0x2e: 0x005f,
    0x30: 0x0060, 0x31: 0x0062, 0x32: 0x0064, 0x33: 0x0065, 0x34: 0x0066, 0x35: 0x0068, 0x36: 0x006e, 0x37: 0x0074,
    0x38: 0x007a, 0x39: 0x007c, 0x3a: 0x007e, 0x3b: 0x0081, 0x3d: 0x0082, 0x3e: 0x0086, 0x3f: 0x0088, 0x40: 0x0089,
    0x41: 0x008a, 0x43: 0x008b, 0x44: 0x008e, 0x45: 0x0092, 0x46: 0x0096, 0x49: 0x0099, 0x4a: 0x009d, 0x4b: 0x00a2,
    0x4c: 0x00a5, 0x4d: 0x00a6, 0x4e: 0x00a8, 0x4f: 0x00aa, 0x50: 0x00ab, 0x51: 0x00ad, 0x52: 0x00af, 0x53: 0x00b2,
    0x56: 0x00b5, 0x57: 0x00b9, 0x58: 0x00bf, 0x59: 0x00c5, 0x5a: 0x00c9, 0x5b: 0x00ca, 0x5c: 0x00cc, 0x5d: 0x00ce,
    0x5e: 0x00d1, 0x5f: 0x00d5, 0x60: 0x00d6, 0x61: 0x00dc, 0x62: 0x00e3, 0x63: 0x00e9, 0x64: 0x00ec, 0x65: 0x00ed,
    0x66: 0x00ee, 0x67: 0x00f2, 0x68: 0x00f5, 0x6a: 0x00f7, 0x6b: 0x00f8, 0x6c: 0x00fc, 0x6d: 0x00ff, 0x6e: 0x0102,
    0x71: 0x0103, 0x72: 0x0106, 0x73: 0x0107, 0x74: 0x010a, 0x75: 0x010c, 0x76: 0x010e, 0x77: 0x0112, 0x7b: 0x0114,
    0x7c: 0x0117, 0x7d: 0x011b, 0x7e: 0x011e, 0x7f: 0x0121, 0x81: 0x0123, 0x83: 0x0124, 0x84: 0x0127, 0x85: 0x0128,
    0x87: 0x012c, 0x8b: 0x012e, 0x8c: 0x0133, 0x8d: 0x0139, 0x8e: 0x013e, 0x90: 0x013f, 0x91: 0x0140, 0x92: 0x0141,
    0x93: 0x0146, 0x95: 0x0149, 0x96: 0x014b, 0x97: 0x014d, 0x98: 0x014f, 0x99: 0x0150, 0x9b: 0x0153, 0x9c: 0x0156,
    0x9d: 0x015a, 0x9e: 0x015d, 0x9f: 0x0161, 0xa0: 0x0163, 0xa1: 0x0164, 0xa2: 0x0166, 0xa3: 0x016a, 0xa4: 0x016c,
    0xa5: 0x016d, 0xa8: 0x0170, 0xa9: 0x0176, 0xaa: 0x017c, 0xab: 0x0182, 0xac: 0x0184, 0xae: 0x0185, 0xaf: 0x0186,
    0xb0: 0x0188, 0xb1: 0x018b, 0xb2: 0x018f, 0xb3: 0x0197, 0xb4: 0x019c, 0xb5: 0x019d, 0xb6: 0x019e, 0xb7: 0x01a3,
    0xb8: 0x01a4, 0xb9: 0x01a6, 0xba: 0x01aa, 0xbb: 0x01ad, 0xbc: 0x01b3, 0xbe: 0x01bb, 0xbf: 0x01be, 0xc0: 0x01bf,
    0xc1: 0x01c2, 0xc2: 0x01ca, 0xc3: 0x01d2, 0xc4: 0x01d9, 0xc5: 0x01da, 0xc6: 0x01dd, 0xc7: 0x01e3, 0xc8: 0x01e6,
    0xc9: 0x01e7, 0xcb: 0x01ec, 0xcc: 0x01ed, 0xce: 0x01f0, 0xd0: 0x01f1, 0xd1: 0x01f3, 0xd2: 0x01f7, 0xd5: 0x01f8,
    0xd6: 0x01fa, 0xd8: 0x01fd, 0xd9: 0x0200, 0xda: 0x0203, 0xdb: 0x0204, 0xdc: 0x0206, 0xe0: 0x0207
}

# Note: 0-7 correspond to 1,2,3,4,5,6,a,14 respectively, see doortables.asm : MultDivInfo

multiply_lookup = {
    0x08: {0x8: 0, 0x10: 1, 0x18: 2, 0x20: 3, 0x30: 5, 0x50: 6, 0xa0: 7},
    0x10: {0x8: 0, 0x10: 0, 0x18: 2, 0x20: 1, 0x30: 2, 0x50: 3, 0xa0: 6},
    0x18: {0x8: 0, 0x10: 1, 0x18: 0, 0x20: 3, 0x30: 1, 0x50: 6, 0xa0: 7},
    0x20: {0x8: 0, 0x10: 0, 0x18: 2, 0x20: 0, 0x30: 2, 0x50: 4, 0xa0: 4},
    0x30: {0x8: 0, 0x10: 0, 0x18: 0, 0x20: 1, 0x30: 0, 0x50: 4, 0xa0: 6},
    0x50: {0x8: 0, 0x10: 0, 0x18: 2, 0x20: 1, 0x30: 2, 0x50: 0, 0xa0: 1},
    0xa0: {0x8: 0, 0x10: 0, 0x18: 2, 0x20: 0, 0x30: 2, 0x50: 0, 0xa0: 0},
}

divisor_lookup = {
    0x08: {0x8: 0, 0x10: 0, 0x18: 0, 0x20: 0, 0x30: 0, 0x50: 0, 0xa0: 0},
    0x10: {0x8: 1, 0x10: 0, 0x18: 1, 0x20: 0, 0x30: 0, 0x50: 0, 0xa0: 0},
    0x18: {0x8: 2, 0x10: 2, 0x18: 0, 0x20: 2, 0x30: 0, 0x50: 2, 0xa0: 2},
    0x20: {0x8: 3, 0x10: 1, 0x18: 3, 0x20: 0, 0x30: 1, 0x50: 1, 0xa0: 0},
    0x30: {0x8: 5, 0x10: 2, 0x18: 1, 0x20: 2, 0x30: 0, 0x50: 2, 0xa0: 2},
    0x50: {0x8: 6, 0x10: 3, 0x18: 6, 0x20: 4, 0x30: 4, 0x50: 0, 0xa0: 0},
    0xa0: {0x8: 7, 0x10: 6, 0x18: 7, 0x20: 4, 0x30: 6, 0x50: 1, 0xa0: 0},
}

# I don't need this right now, but I don't want to throw it away either
# Note: this value + 0x028000 is where the header is for the room (PC not SNES addressing)

# room_header_lookup = {
#     0x0: 0x462, 0x1: 0x46c, 0x2: 0x47a, 0x3: 0x5dd, 0x4: 0x485, 0x5: 0x490, 0x6: 0x490, 0x7: 0x497,
#     0x8: 0x4a2, 0x9: 0x4a9, 0xa: 0x4b5, 0xb: 0x4c0, 0xc: 0x4cb, 0xd: 0x4d8, 0xe: 0x4df, 0xf: 0x4ea,
#     0x10: 0x4ea, 0x11: 0x4f1, 0x12: 0x4fc, 0x13: 0x503, 0x14: 0x511, 0x15: 0x518, 0x16: 0x523, 0x17: 0x52e,
#     0x18: 0xc73, 0x19: 0x53a, 0x1a: 0x541, 0x1b: 0x54d, 0x1c: 0x558, 0x1d: 0x563, 0x1e: 0x56e, 0x1f: 0x579,
#     0x20: 0x584, 0x21: 0x58b, 0x22: 0x58b, 0x23: 0x503, 0x24: 0x592, 0x25: 0x599, 0x26: 0x599, 0x27: 0x5a6,
#     0x28: 0x5b2, 0x29: 0x5bd, 0x2a: 0x5c4, 0x2b: 0x5cb, 0x2c: 0xc73, 0x2d: 0x5d6, 0x2e: 0x5d6, 0x2f: 0x5dd,
#     0x30: 0x5e4, 0x31: 0x5ef, 0x32: 0x5fb, 0x33: 0x606, 0x34: 0x60d, 0x35: 0x618, 0x36: 0x61f, 0x37: 0x618,
#     0x38: 0x626, 0x39: 0x631, 0x3a: 0x63b, 0x3b: 0x646, 0x3c: 0x651, 0x3d: 0x658, 0x3e: 0x663, 0x3f: 0x66e,
#     0x40: 0x67a, 0x41: 0x686, 0x42: 0x691, 0x43: 0x69d, 0x44: 0x6a4, 0x45: 0x6ab, 0x46: 0x6b6, 0x47: 0x6bd,
#     0x48: 0x6bd, 0x49: 0x6bd, 0x4a: 0x6c4, 0x4b: 0x6d0, 0x4c: 0x6da, 0x4d: 0x6e5, 0x4e: 0x6f0, 0x4f: 0x6fb,
#     0x50: 0x705, 0x51: 0x713, 0x52: 0x71e, 0x53: 0x72c, 0x54: 0x737, 0x55: 0x742, 0x56: 0x749, 0x57: 0x750,
#     0x58: 0x757, 0x59: 0x75e, 0x5a: 0x765, 0x5b: 0x76c, 0x5c: 0x773, 0x5d: 0x77e, 0x5e: 0x789, 0x5f: 0x794,
#     0x60: 0x7a0, 0x61: 0x7a7, 0x62: 0x7a0, 0x63: 0x7b2, 0x64: 0x7bd, 0x65: 0x7c8, 0x66: 0x7d2, 0x67: 0x7dd,
#     0x68: 0x7e4, 0x69: 0x7eb, 0x6a: 0x7eb, 0x6b: 0x7f7, 0x6c: 0x802, 0x6d: 0x80d, 0x6e: 0x814, 0x6f: 0x81f,
#     0x70: 0x81f, 0x71: 0x82b, 0x72: 0x836, 0x73: 0x841, 0x74: 0x848, 0x75: 0x84f, 0x76: 0x856, 0x77: 0x863,
#     0x78: 0x870, 0x79: 0x870, 0x7a: 0x870, 0x7b: 0x870, 0x7c: 0x87a, 0x7d: 0x881, 0x7e: 0x88b, 0x7f: 0x896,
#     0x80: 0x8a1, 0x81: 0x8ac, 0x82: 0x8ac, 0x83: 0x8b3, 0x84: 0x8ba, 0x85: 0x8c1, 0x86: 0x8c8, 0x87: 0x8c8,
#     0x88: 0x8d4, 0x89: 0x8d4, 0x8a: 0x8de, 0x8b: 0x8de, 0x8c: 0x8e5, 0x8d: 0x8f2, 0x8e: 0x8f9, 0x8f: 0x904,
#     0x90: 0x904, 0x91: 0x90b, 0x92: 0x916, 0x93: 0x91d, 0x94: 0x928, 0x95: 0x928, 0x96: 0x92f, 0x97: 0x93a,
#     0x98: 0x945, 0x99: 0x950, 0x9a: 0x95b, 0x9b: 0x95b, 0x9c: 0x965, 0x9d: 0x96c, 0x9e: 0x976, 0x9f: 0x981,
#     0xa0: 0x988, 0xa1: 0x993, 0xa2: 0x99a, 0xa3: 0x993, 0xa4: 0x9a5, 0xa5: 0x9ac, 0xa6: 0x9b7, 0xa7: 0x9c2,
#     0xa8: 0x9cc, 0xa9: 0x9d3, 0xaa: 0x9dd, 0xab: 0x9e4, 0xac: 0x9ef, 0xad: 0x9f6, 0xae: 0x9f6, 0xaf: 0xa01,
#     0xb0: 0xa08, 0xb1: 0xa14, 0xb2: 0xa1e, 0xb3: 0xa25, 0xb4: 0xa2c, 0xb5: 0xa37, 0xb6: 0xa42, 0xb7: 0x50a,
#     0xb8: 0xa4d, 0xb9: 0xa54, 0xba: 0xa5b, 0xbb: 0xa62, 0xbc: 0xa69, 0xbd: 0xa74, 0xbe: 0xa74, 0xbf: 0xa7f,
#     0xc0: 0xa86, 0xc1: 0xa92, 0xc2: 0xa99, 0xc3: 0xaa0, 0xc4: 0xaa7, 0xc5: 0xab2, 0xc6: 0x50a, 0xc7: 0xab9,
#     0xc8: 0xac0, 0xc9: 0xac7, 0xca: 0xace, 0xcb: 0xace, 0xcc: 0xace, 0xcd: 0xad5, 0xce: 0xad5, 0xcf: 0xadf,
#     0xd0: 0xadf, 0xd1: 0xaeb, 0xd2: 0xaf6, 0xd3: 0xb01, 0xd4: 0xb01, 0xd5: 0xab2, 0xd6: 0x50a, 0xd7: 0xb01,
#     0xd8: 0xb01, 0xd9: 0xb08, 0xda: 0xb0f, 0xdb: 0xace, 0xdc: 0xace, 0xdd: 0xb1a, 0xde: 0xb1a, 0xdf: 0xb21,
#     0xe0: 0xb2c, 0xe1: 0xb37, 0xe2: 0xb3e, 0xe3: 0xb45, 0xe4: 0xb4c, 0xe5: 0xb4c, 0xe6: 0xb53, 0xe7: 0xb53,
#     0xe8: 0xb5a, 0xe9: 0xb68, 0xea: 0xb68, 0xeb: 0xb73, 0xec: 0xb7e, 0xed: 0xb7e, 0xee: 0xb8a, 0xef: 0xb94,
#     0xf0: 0xb53, 0xf1: 0xb53, 0xf2: 0xba0, 0xf3: 0xba0, 0xf4: 0xba5, 0xf5: 0xba5, 0xf6: 0xbac, 0xf7: 0xbac,
#     0xf8: 0xbac, 0xf9: 0xbba, 0xfa: 0xbc1, 0xfb: 0xbcc, 0xfc: 0xbd7, 0xfd: 0xbd7, 0xfe: 0xbba, 0xff: 0xbe3
# }
