import collections
from BaseClasses import RegionType
from Regions import create_lw_region, create_dw_region, create_cave_region, create_dungeon_region, create_menu_region

def create_inverted_regions(world, player):

    world.regions += [
        create_menu_region(player, 'Menu', None, ['Links House S&Q', 'Dark Sanctuary S&Q', 'Old Man S&Q', 'Castle Ledge S&Q']),
        create_lw_region(player, 'Light World', ['Mushroom', 'Bottle Merchant', 'Flute Spot', 'Sunken Treasure', 'Purple Chest', 'Bombos Tablet'],
                         ["Blinds Hideout", "Hyrule Castle Secret Entrance Drop", 'Kings Grave Outer Rocks', 'Dam',
                          'Inverted Big Bomb Shop', 'Tavern North', 'Chicken House', 'Aginahs Cave', 'Sahasrahlas Hut', 'Kakariko Well Drop', 'Kakariko Well Cave',
                          'Blacksmiths Hut', 'Bat Cave Drop Ledge', 'Bat Cave Cave', 'Sick Kids House', 'Hobo Bridge', 'Lost Woods Hideout Drop', 'Lost Woods Hideout Stump',
                          'Lumberjack Tree Tree', 'Lumberjack Tree Cave', 'Mini Moldorm Cave', 'Ice Rod Cave', 'Lake Hylia Central Island Pier', 'Lake Hylia Island Pier', 'Lake Hylia Warp',
                          'Bonk Rock Cave', 'Library', 'Two Brothers House (East)', 'Desert Palace Stairs', 'Eastern Palace', 'Master Sword Meadow',
                          'Sanctuary', 'Sanctuary Grave', 'Death Mountain Entrance Rock', 'Light World River Drop',
                          'Elder House (East)', 'Elder House (West)', 'North Fairy Cave', 'North Fairy Cave Drop', 'Lost Woods Gamble', 'Snitch Lady (East)', 'Snitch Lady (West)', 'Tavern (Front)',
                          'Kakariko Shop', 'Long Fairy Cave', 'Good Bee Cave', '20 Rupee Cave', 'Cave Shop (Lake Hylia)',
                          'Bonk Fairy (Light)', '50 Rupee Cave', 'Fortune Teller (Light)', 'Lake Hylia Fairy', 'Light Hype Fairy', 'Desert Fairy', 'Lumberjack House', 'Lake Hylia Fortune Teller', 'Kakariko Gamble Game',
                          'East Dark World Mirror Spot', 'West Dark World Mirror Spot', 'South Dark World Mirror Spot', 'Cave 45', 'Checkerboard Cave', 'Mire Mirror Spot', 'Hammer Peg Area Mirror Spot', 
                          'Shopping Mall Mirror Spot', 'Skull Woods Mirror Spot', 'Inverted Pyramid Entrance','Hyrule Castle Entrance (South)', 'Secret Passage Outer Bushes', 'Bush Covered Lawn Outer Bushes',
                          'Potion Shop Outer Bushes', 'Graveyard Cave Outer Bushes', 'Bomb Hut Outer Bushes']),
        create_lw_region(player, 'Bush Covered Lawn', None, ['Bush Covered House', 'Bush Covered Lawn Inner Bushes', 'Bush Covered Lawn Mirror Spot']),
        create_lw_region(player, 'Bomb Hut Area', None, ['Light World Bomb Hut', 'Bomb Hut Inner Bushes', 'Bomb Hut Mirror Spot']),
        create_lw_region(player, 'Hyrule Castle Secret Entrance Area', None, ['Hyrule Castle Secret Entrance Stairs', 'Secret Passage Inner Bushes']),
        create_lw_region(player, 'Death Mountain Entrance', None, ['Old Man Cave (West)', 'Death Mountain Entrance Drop', 'Bumper Cave Entrance Mirror Spot']),
        create_lw_region(player, 'Lake Hylia Central Island', None, ['Capacity Upgrade', 'Lake Hylia Central Island Mirror Spot']),
        create_cave_region(player, 'Blinds Hideout', 'a bounty of five items',
                           ["Blind's Hideout - Left", "Blind's Hideout - Right", "Blind's Hideout - Far Left",
                            "Blind's Hideout - Far Right"], ['Blinds Hideout N']),
        create_cave_region(player, 'Blinds Hideout (Top)', 'a bounty of five items', ["Blind's Hideout - Top"]),
        create_lw_region(player, 'Northeast Light World', None, ['Zoras River', 'Waterfall of Wishing Cave', 'Potion Shop Outer Rock', 'Catfish Mirror Spot', 'Northeast Light World Warp']),
        create_lw_region(player, 'Waterfall of Wishing Cave', None, ['Waterfall of Wishing', 'Northeast Light World Return']),
        create_lw_region(player, 'Potion Shop Area', None, ['Potion Shop', 'Potion Shop Inner Bushes', 'Potion Shop Inner Rock', 'Potion Shop Mirror Spot', 'Potion Shop River Drop']),
        create_lw_region(player, 'Graveyard Cave Area', None, ['Graveyard Cave', 'Graveyard Cave Inner Bushes', 'Graveyard Cave Mirror Spot']),
        create_lw_region(player, 'River', None, ['Light World Pier', 'Potion Shop Pier']),
        create_cave_region(player, 'Hyrule Castle Secret Entrance', 'a drop\'s exit', ['Link\'s Uncle', 'Secret Passage'], ['Hyrule Castle Secret Entrance Exit']),
        create_dungeon_region(player, 'Sewer Drop', 'a drop\'s exit', None, ['Sewer Drop']), # This exists only to be referenced for access checks
        create_lw_region(player, 'Zoras River', ['King Zora', 'Zora\'s Ledge']),
        create_cave_region(player, 'Waterfall of Wishing', 'a cave with two chests', ['Waterfall Fairy - Left', 'Waterfall Fairy - Right']),
        create_lw_region(player, 'Kings Grave Area', None, ['Kings Grave', 'Kings Grave Inner Rocks']),
        create_cave_region(player, 'Kings Grave', 'a cave with a chest', ['King\'s Tomb']),
        create_cave_region(player, 'North Fairy Cave', 'a drop\'s exit', None, ['North Fairy Cave Exit']),
        create_cave_region(player, 'Dam', 'the dam', ['Floodgate', 'Floodgate Chest']),
        create_cave_region(player, 'Inverted Links House', 'your house', ['Link\'s House'], ['Inverted Links House Exit']),
        create_cave_region(player, 'Chris Houlihan Room', 'I AM ERROR', None, ['Chris Houlihan Room Exit']),
        create_cave_region(player, 'Tavern', 'the tavern', ['Kakariko Tavern']),
        create_cave_region(player, 'Elder House', 'a connector', None, ['Elder House Exit (East)', 'Elder House Exit (West)']),
        create_cave_region(player, 'Snitch Lady (East)', 'a boring house'),
        create_cave_region(player, 'Snitch Lady (West)', 'a boring house'),
        create_cave_region(player, 'Bush Covered House', 'the grass man'),
        create_cave_region(player, 'Tavern (Front)', 'the tavern'),
        create_cave_region(player, 'Light World Bomb Hut', 'a restock room'),
        create_cave_region(player, 'Kakariko Shop', 'a common shop', ['Kakariko Shop - Left', 'Kakariko Shop - Middle', 'Kakariko Shop - Right']),
        create_cave_region(player, 'Fortune Teller (Light)', 'a fortune teller'),
        create_cave_region(player, 'Lake Hylia Fortune Teller', 'a fortune teller'),
        create_cave_region(player, 'Lumberjack House', 'a boring house'),
        create_cave_region(player, 'Bonk Fairy (Light)', 'a fairy fountain'),
        create_cave_region(player, 'Bonk Fairy (Dark)', 'a fairy fountain'),
        create_cave_region(player, 'Lake Hylia Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Swamp Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Desert Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Dark Lake Hylia Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Dark Lake Hylia Ledge Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Dark Desert Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Dark Death Mountain Healer Fairy', 'a fairy fountain'),
        create_cave_region(player, 'Chicken House', 'a house with a chest', ['Chicken House']),
        create_cave_region(player, 'Aginahs Cave', 'a cave with a chest', ['Aginah\'s Cave']),
        create_cave_region(player, 'Sahasrahlas Hut', 'Sahasrahla', ['Sahasrahla\'s Hut - Left', 'Sahasrahla\'s Hut - Middle', 'Sahasrahla\'s Hut - Right', 'Sahasrahla']),
        create_cave_region(player, 'Kakariko Well (top)', 'a drop',
                           ['Kakariko Well - Left', 'Kakariko Well - Middle', 'Kakariko Well - Right',
                            'Kakariko Well - Bottom'],
                           ['Kakariko Well (top to bottom)', 'Kakariko Well (top to back)']),
        create_cave_region(player, 'Kakariko Well (back)', 'a drop', ['Kakariko Well - Top']),
        create_cave_region(player, 'Kakariko Well (bottom)', 'a drop\'s exit', None, ['Kakariko Well Exit']),
        create_cave_region(player, 'Blacksmiths Hut', 'the smith', ['Blacksmith', 'Missing Smith']),
        create_lw_region(player, 'Bat Cave Drop Ledge', None, ['Bat Cave Drop']),
        create_cave_region(player, 'Bat Cave (right)', 'a drop', ['Magic Bat'], ['Bat Cave Door']),
        create_cave_region(player, 'Bat Cave (left)', 'a drop\'s exit', None, ['Bat Cave Exit']),
        create_cave_region(player, 'Sick Kids House', 'the sick kid', ['Sick Kid']),
        create_lw_region(player, 'Hobo Bridge', ['Hobo']),
        create_cave_region(player, 'Lost Woods Hideout (top)', 'a drop\'s exit', ['Lost Woods Hideout'], ['Lost Woods Hideout (top to bottom)']),
        create_cave_region(player, 'Lost Woods Hideout (bottom)', 'a drop\'s exit', None, ['Lost Woods Hideout Exit']),
        create_cave_region(player, 'Lumberjack Tree (top)', 'a drop\'s exit', ['Lumberjack Tree'], ['Lumberjack Tree (top to bottom)']),
        create_cave_region(player, 'Lumberjack Tree (bottom)', 'a drop\'s exit', None, ['Lumberjack Tree Exit']),
        create_cave_region(player, 'Cave 45', 'a cave with an item', ['Cave 45']),
        create_cave_region(player, 'Graveyard Cave', 'a cave with an item', ['Graveyard Cave']),
        create_cave_region(player, 'Checkerboard Cave', 'a cave with an item', ['Checkerboard Cave']),
        create_cave_region(player, 'Long Fairy Cave', 'a fairy fountain'),
        create_cave_region(player, 'Mini Moldorm Cave', 'a bounty of five items', ['Mini Moldorm Cave - Far Left', 'Mini Moldorm Cave - Left', 'Mini Moldorm Cave - Right',
                                                                           'Mini Moldorm Cave - Far Right', 'Mini Moldorm Cave - Generous Guy']),
        create_cave_region(player, 'Ice Rod Cave', 'a cave with a chest', ['Ice Rod Cave']),
        create_cave_region(player, 'Good Bee Cave', 'a cold bee'),
        create_cave_region(player, '20 Rupee Cave', 'a cave with some cash'),
        create_cave_region(player, 'Cave Shop (Lake Hylia)', 'a common shop', ['Lake Hylia Shop - Left', 'Lake Hylia Shop - Middle', 'Lake Hylia Shop - Right']),
        create_cave_region(player, 'Cave Shop (Dark Death Mountain)', 'a common shop', ['Dark Death Mountain Shop - Left', 'Dark Death Mountain Shop - Middle', 'Dark Death Mountain Shop - Right']),
        create_cave_region(player, 'Bonk Rock Cave', 'a cave with a chest', ['Bonk Rock Cave']),
        create_cave_region(player, 'Library', 'the library', ['Library']),
        create_cave_region(player, 'Kakariko Gamble Game', 'a game of chance'),
        create_cave_region(player, 'Potion Shop', 'the potion shop', ['Potion Shop', 'Potion Shop - Left', 'Potion Shop - Middle', 'Potion Shop - Right']),
        create_lw_region(player, 'Lake Hylia Island', ['Lake Hylia Island']),
        create_cave_region(player, 'Capacity Upgrade', 'the queen of fairies', ['Capacity Upgrade - Left', 'Capacity Upgrade - Right']),
        create_cave_region(player, 'Two Brothers House', 'a connector', None, ['Two Brothers House Exit (East)', 'Two Brothers House Exit (West)']),
        create_lw_region(player, 'Maze Race Ledge', ['Maze Race'], ['Two Brothers House (West)', 'Maze Race Mirror Spot', 'Maze Race Ledge Drop']),
        create_cave_region(player, '50 Rupee Cave', 'a cave with some cash'),
        create_lw_region(player, 'Desert Ledge', ['Desert Ledge'], ['Desert Palace Entrance (North) Rocks', 'Desert Palace Entrance (West)', 'Desert Ledge Drop']),
        create_lw_region(player, 'Desert Palace Stairs', None, ['Desert Palace Entrance (South)', 'Desert Palace Stairs Mirror Spot']),
        create_lw_region(player, 'Desert Palace Lone Stairs', None, ['Desert Palace Stairs Drop', 'Desert Palace Entrance (East)']),
        create_lw_region(player, 'Desert Palace Entrance (North) Spot', None, ['Desert Palace Entrance (North)', 'Desert Ledge Return Rocks', 'Desert Palace North Mirror Spot']),
        create_lw_region(player, 'Master Sword Meadow', ['Master Sword Pedestal']),
        create_cave_region(player, 'Lost Woods Gamble', 'a game of chance'),
        create_lw_region(player, 'Hyrule Castle Ledge', None, ['Hyrule Castle Entrance (East)', 'Hyrule Castle Entrance (West)', 'Inverted Ganons Tower', 'Hyrule Castle Ledge Courtyard Drop', 'Inverted Pyramid Hole']),
        create_cave_region(player, 'Old Man Cave', 'a connector', ['Old Man'], ['Old Man Cave Exit (East)']),
        create_cave_region(player, 'Old Man Cave Ledge', 'a connector', None, ['Old Man Cave Exit (West)', 'Old Man Cave Dropdown']),
        create_cave_region(player, 'Old Man House', 'a connector', None, ['Old Man House Exit (Bottom)', 'Old Man House Front to Back']),
        create_cave_region(player, 'Old Man House Back', 'a connector', None, ['Old Man House Exit (Top)', 'Old Man House Back to Front']),
        create_lw_region(player, 'Death Mountain', None, ['Old Man Cave (East)', 'Old Man House (Bottom)', 'Old Man House (Top)', 'Death Mountain Return Cave (East)', 'Spectacle Rock Cave', 
                                                  'Spectacle Rock Cave Peak', 'Spectacle Rock Cave (Bottom)', 'Broken Bridge (West)', 'Death Mountain Mirror Spot']),
        create_cave_region(player, 'Death Mountain Return Cave (left)', 'a connector', None, ['Death Mountain Return Cave Exit (West)', 'Death Mountain Return Cave E']),
        create_cave_region(player, 'Death Mountain Return Cave (right)', 'a connector', None, ['Death Mountain Return Cave Exit (East)', 'Death Mountain Return Cave W']),
        create_lw_region(player, 'Death Mountain Return Ledge', None, ['Death Mountain Return Ledge Drop', 'Death Mountain Return Cave (West)', 'Bumper Cave Ledge Mirror Spot']),
        create_cave_region(player, 'Spectacle Rock Cave (Top)', 'a connector', ['Spectacle Rock Cave'], ['Spectacle Rock Cave Drop', 'Spectacle Rock Cave Exit (Top)']),
        create_cave_region(player, 'Spectacle Rock Cave (Bottom)', 'a connector', None, ['Spectacle Rock Cave Exit']),
        create_cave_region(player, 'Spectacle Rock Cave (Peak)', 'a connector', None, ['Spectacle Rock Cave Peak Drop', 'Spectacle Rock Cave Exit (Peak)']),
        create_lw_region(player, 'East Death Mountain (Bottom)', None, ['Broken Bridge (East)', 'Paradox Cave (Bottom)', 'Paradox Cave (Middle)', 'East Death Mountain Mirror Spot (Bottom)', 'Hookshot Fairy', 
                                                                'Fairy Ascension Rocks', 'Spiral Cave (Bottom)']),
        create_cave_region(player, 'Hookshot Fairy', 'fairies deep in a cave'),
        create_cave_region(player, 'Paradox Cave Front', 'a connector', None, ['Paradox Cave Push Block Reverse', 'Paradox Cave Exit (Bottom)', 'Light World Death Mountain Shop']),
        create_cave_region(player, 'Paradox Cave Chest Area', 'a connector', ['Paradox Cave Lower - Far Left',
                                                                      'Paradox Cave Lower - Left',
                                                                      'Paradox Cave Lower - Right',
                                                                      'Paradox Cave Lower - Far Right',
                                                                      'Paradox Cave Lower - Middle'],
                           ['Paradox Cave Push Block', 'Paradox Cave Bomb Jump', 'Paradox Cave Chest Area NE']),
        create_cave_region(player, 'Paradox Cave Bomb Area', 'a connector', ['Paradox Cave Upper - Left',
                                                                             'Paradox Cave Upper - Right']),
        create_cave_region(player, 'Paradox Cave', 'a connector', None, ['Paradox Cave Exit (Middle)', 'Paradox Cave Exit (Top)', 'Paradox Cave Drop']),
        create_cave_region(player, 'Light World Death Mountain Shop', 'a common shop', ['Paradox Shop - Left', 'Paradox Shop - Middle', 'Paradox Shop - Right']),
        create_lw_region(player, 'East Death Mountain (Top)', ['Floating Island'], ['Paradox Cave (Top)', 'Death Mountain (Top)', 'Spiral Cave Ledge Access', 'East Death Mountain Drop', 'East Death Mountain Mirror Spot (Top)', 'Fairy Ascension Ledge Access', 'Mimic Cave Ledge Access',
                                                                            'Floating Island Mirror Spot']),
        create_lw_region(player, 'Spiral Cave Ledge', None, ['Spiral Cave', 'Spiral Cave Ledge Drop', 'Dark Death Mountain Ledge Mirror Spot (West)']),
        create_lw_region(player, 'Mimic Cave Ledge', None, ['Mimic Cave', 'Mimic Cave Ledge Drop', 'Dark Death Mountain Ledge Mirror Spot (East)']),
        create_cave_region(player, 'Spiral Cave (Top)', 'a connector', ['Spiral Cave'], ['Spiral Cave (top to bottom)', 'Spiral Cave Exit (Top)']),
        create_cave_region(player, 'Spiral Cave (Bottom)', 'a connector', None, ['Spiral Cave Exit']),
        create_lw_region(player, 'Fairy Ascension Plateau', None, ['Fairy Ascension Drop', 'Fairy Ascension Cave (Bottom)']),
        create_cave_region(player, 'Fairy Ascension Cave (Bottom)', 'a connector', None, ['Fairy Ascension Cave Climb', 'Fairy Ascension Cave Exit (Bottom)']),
        create_cave_region(player, 'Fairy Ascension Cave (Drop)', 'a connector', None, ['Fairy Ascension Cave Pots']),
        create_cave_region(player, 'Fairy Ascension Cave (Top)', 'a connector', None, ['Fairy Ascension Cave Exit (Top)', 'Fairy Ascension Cave Drop']),
        create_lw_region(player, 'Fairy Ascension Ledge', None, ['Fairy Ascension Ledge Drop', 'Fairy Ascension Cave (Top)', 'Laser Bridge Mirror Spot']),
        create_lw_region(player, 'Death Mountain (Top)', ['Ether Tablet', 'Spectacle Rock'], ['East Death Mountain (Top)', 'Tower of Hera', 'Death Mountain Drop', 'Death Mountain (Top) Mirror Spot']),
        create_dw_region(player, 'Bumper Cave Ledge', ['Bumper Cave Ledge'], ['Bumper Cave Ledge Drop', 'Bumper Cave (Top)']),

        create_dw_region(player, 'East Dark World', ['Pyramid'], ['Pyramid Fairy', 'South Dark World Bridge', 'Palace of Darkness', 'Dark Lake Hylia Drop (East)', 
                                                          'Dark Lake Hylia Fairy', 'Palace of Darkness Hint', 'East Dark World Hint', 'Northeast Dark World Broken Bridge Pass', 'East Dark World Teleporter', 'EDW Flute']),
        create_dw_region(player, 'Catfish', ['Catfish'], ['Catfish Exit Rock']),
        create_dw_region(player, 'Northeast Dark World', None, ['West Dark World Gap', 'Dark World Potion Shop', 'East Dark World Broken Bridge Pass', 'NEDW Flute', 'Dark Lake Hylia Teleporter', 'Catfish Entrance Rock']),
        create_cave_region(player, 'Palace of Darkness Hint', 'a storyteller'),
        create_cave_region(player, 'East Dark World Hint', 'a storyteller'),
        create_dw_region(player, 'South Dark World', ['Stumpy', 'Digging Game'], ['Dark Lake Hylia Drop (South)', 'Hype Cave', 'Swamp Palace', 'Village of Outcasts Heavy Rock', 'East Dark World Bridge', 'Inverted Links House', 'Archery Game', 'Bonk Fairy (Dark)', 
                                              'Dark Lake Hylia Shop', 'South Dark World Teleporter', 'Post Aga Teleporter', 'SDW Flute']),
        create_cave_region(player, 'Inverted Big Bomb Shop', 'the bomb shop'),
        create_cave_region(player, 'Archery Game', 'a game of skill'),
        create_dw_region(player, 'Dark Lake Hylia', None, ['East Dark World Pier', 'Dark Lake Hylia Ledge Pier', 'Ice Palace Missing Wall']),
        create_dw_region(player, 'Dark Lake Hylia Central Island', None, ['Dark Lake Hylia Shallows', 'Ice Palace', 'Dark Lake Hylia Central Island Teleporter']),
        create_dw_region(player, 'Dark Lake Hylia Ledge', None, ['Dark Lake Hylia Ledge Drop', 'Dark Lake Hylia Ledge Fairy', 'Dark Lake Hylia Ledge Hint', 'Dark Lake Hylia Ledge Spike Cave', 'DLHL Flute']),
        create_cave_region(player, 'Dark Lake Hylia Ledge Hint', 'a storyteller'),
        create_cave_region(player, 'Dark Lake Hylia Ledge Spike Cave', 'a spiky hint'),
        create_cave_region(player, 'Hype Cave', 'a bounty of five items', ['Hype Cave - Top', 'Hype Cave - Middle Right', 'Hype Cave - Middle Left',
                                                                   'Hype Cave - Bottom', 'Hype Cave - Generous Guy']),
        create_dw_region(player, 'West Dark World', ['Frog'], ['Village of Outcasts Drop', 'East Dark World River Pier', 'Brewery', 'C-Shaped House', 'Chest Game', 'Thieves Town', 'Bumper Cave Entrance Rock',
                                                       'Skull Woods Forest', 'Village of Outcasts Pegs', 'Village of Outcasts Eastern Rocks', 'Red Shield Shop', 'Inverted Dark Sanctuary', 'Fortune Teller (Dark)', 'Dark World Lumberjack Shop',
                                                       'West Dark World Teleporter', 'WDW Flute']),
        create_dw_region(player, 'Dark Grassy Lawn', None, ['Grassy Lawn Pegs', 'Dark World Shop', 'Dark Grassy Lawn Flute']),
        create_dw_region(player, 'Hammer Peg Area', ['Dark Blacksmith Ruins'], ['Dark World Hammer Peg Cave', 'Peg Area Rocks', 'Hammer Peg Area Flute']),
        create_dw_region(player, 'Bumper Cave Entrance', None, ['Bumper Cave (Bottom)', 'Bumper Cave Entrance Drop']),
        create_cave_region(player, 'Fortune Teller (Dark)', 'a fortune teller'),
        create_cave_region(player, 'Village of Outcasts Shop', 'a common shop', ['Village of Outcasts Shop - Left', 'Village of Outcasts Shop - Middle', 'Village of Outcasts Shop - Right']),
        create_cave_region(player, 'Dark Lake Hylia Shop', 'a common shop', ['Dark Lake Hylia Shop - Left', 'Dark Lake Hylia Shop - Middle', 'Dark Lake Hylia Shop - Right']),
        create_cave_region(player, 'Dark World Lumberjack Shop', 'a common shop', ['Dark Lumberjack Shop - Left', 'Dark Lumberjack Shop - Middle', 'Dark Lumberjack Shop - Right']),
        create_cave_region(player, 'Dark World Potion Shop', 'a common shop', ['Dark Potion Shop - Left', 'Dark Potion Shop - Middle', 'Dark Potion Shop - Right']),
        create_cave_region(player, 'Dark World Hammer Peg Cave', 'a cave with an item', ['Peg Cave']),
        create_cave_region(player, 'Pyramid Fairy', 'a cave with two chests', ['Pyramid Fairy - Left', 'Pyramid Fairy - Right']),
        create_cave_region(player, 'Brewery', 'a house with a chest', ['Brewery']),
        create_cave_region(player, 'C-Shaped House', 'a house with a chest', ['C-Shaped House']),
        create_cave_region(player, 'Chest Game', 'a game of 16 chests', ['Chest Game']),
        create_cave_region(player, 'Red Shield Shop', 'the rare shop', ['Red Shield Shop - Left', 'Red Shield Shop - Middle', 'Red Shield Shop - Right']),
        create_cave_region(player, 'Inverted Dark Sanctuary', 'a storyteller', None, ['Inverted Dark Sanctuary Exit']),
        create_cave_region(player, 'Bumper Cave', 'a connector', None, ['Bumper Cave Exit (Bottom)', 'Bumper Cave Exit (Top)']),
        create_dw_region(player, 'Skull Woods Forest', None, ['Skull Woods First Section Hole (East)', 'Skull Woods First Section Hole (West)', 'Skull Woods First Section Hole (North)',
                                                      'Skull Woods First Section Door', 'Skull Woods Second Section Door (East)']),
        create_dw_region(player, 'Skull Woods Forest (West)', None, ['Skull Woods Second Section Hole', 'Skull Woods Second Section Door (West)', 'Skull Woods Final Section']),
        create_dw_region(player, 'Dark Desert',  None, ['Misery Mire', 'Mire Shed', 'Dark Desert Hint', 'Dark Desert Fairy', 'DD Flute']),
        create_dw_region(player, 'Dark Desert Ledge',  None, ['Dark Desert Drop', 'Dark Desert Teleporter']),
        create_cave_region(player, 'Mire Shed', 'a cave with two chests', ['Mire Shed - Left', 'Mire Shed - Right']),
        create_cave_region(player, 'Dark Desert Hint', 'a storyteller'),
        create_dw_region(player, 'Dark Death Mountain', None, ['Dark Death Mountain Drop (East)', 'Inverted Agahnims Tower', 'Superbunny Cave (Top)', 'Hookshot Cave', 'Turtle Rock', 
                                                      'Spike Cave', 'Dark Death Mountain Fairy', 'Dark Death Mountain Teleporter (West)', 'Turtle Rock Tail Drop', 'DDM Flute']),
        create_dw_region(player, 'Dark Death Mountain Ledge', None, ['Dark Death Mountain Ledge (East)', 'Dark Death Mountain Ledge (West)']),
        create_dw_region(player, 'Turtle Rock (Top)', None, ['Dark Death Mountain Teleporter (East)', 'Turtle Rock Drop']),
        create_dw_region(player, 'Dark Death Mountain Isolated Ledge', None, ['Turtle Rock Isolated Ledge Entrance']),
        create_dw_region(player, 'Dark Death Mountain (East Bottom)', None, ['Superbunny Cave (Bottom)', 'Cave Shop (Dark Death Mountain)', 'Dark Death Mountain Teleporter (East Bottom)', 'EDDM Flute']),
        create_cave_region(player, 'Superbunny Cave (Top)', 'a connector', ['Superbunny Cave - Top', 'Superbunny Cave - Bottom'], ['Superbunny Cave Exit (Top)']),
        create_cave_region(player, 'Superbunny Cave (Bottom)', 'a connector', None, ['Superbunny Cave Climb', 'Superbunny Cave Exit (Bottom)']),
        create_cave_region(player, 'Spike Cave', 'Spike Cave', ['Spike Cave']),
        create_cave_region(player, 'Hookshot Cave (Front)', 'a connector', None,
                           ['Hookshot Cave Front to Middle', 'Hookshot Cave Front Exit', 'Hookshot Cave Bonk Path', 'Hookshot Cave Hook Path']),
        create_cave_region(player, 'Hookshot Cave (Bonk Islands)', 'a connector', ['Hookshot Cave - Bottom Right']),
        create_cave_region(player, 'Hookshot Cave (Hook Islands)', 'a connector', ['Hookshot Cave - Top Right', 'Hookshot Cave - Top Left', 'Hookshot Cave - Bottom Left']),
        create_cave_region(player, 'Hookshot Cave (Back)', 'a connector', None, ['Hookshot Cave Back to Middle', 'Hookshot Cave Back Exit']),
        create_cave_region(player, 'Hookshot Cave (Middle)', 'a connector', None, ['Hookshot Cave Middle to Back', 'Hookshot Cave Middle to Front']),

        create_dw_region(player, 'Death Mountain Floating Island (Dark World)', None, ['Floating Island Drop', 'Hookshot Cave Back Entrance']),
        create_cave_region(player, 'Mimic Cave', 'Mimic Cave', ['Mimic Cave']),

        create_cave_region(player, 'Pyramid', 'a drop\'s exit', ['Ganon'], ['Ganon Drop']),
        create_cave_region(player, 'Bottom of Pyramid', 'a drop\'s exit', None, ['Pyramid Exit']),
        create_dw_region(player, 'Pyramid Ledge', None, ['Pyramid Drop']),  # houlihan room exits here in inverted
        
        # to simplify flute connections
        create_cave_region(player, 'The Sky', 'A Dark Sky', None, ['DDM Landing','NEDW Landing', 'WDW Landing', 'SDW Landing', 'EDW Landing', 'DD Landing', 'DLHL Landing']),

        create_lw_region(player, 'Desert Northern Cliffs'),
        create_lw_region(player, 'Death Mountain Bunny Descent Area')
    ]


def mark_dark_world_regions(world, player):
    # cross world caves may have some sections marked as both in_light_world, and in_dark_work.
    # That is ok. the bunny logic will check for this case and incorporate special rules.
    queue = collections.deque(region for region in world.get_regions(player) if region.type == RegionType.DarkWorld)
    seen = set(queue)
    while queue:
        current = queue.popleft()
        current.is_dark_world = True
        for exit in current.exits:
            if exit.connected_region is None or exit.connected_region.type == RegionType.LightWorld:  # todo: remove none check
                # Don't venture into the light world
                continue
            if exit.connected_region not in seen:
                seen.add(exit.connected_region)
                queue.append(exit.connected_region)

    queue = collections.deque(region for region in world.get_regions(player) if region.type == RegionType.LightWorld)
    seen = set(queue)
    while queue:
        current = queue.popleft()
        current.is_light_world = True
        for exit in current.exits:
            if exit.connected_region is not None:
                if exit.connected_region.type == RegionType.DarkWorld:
                    # Don't venture into the dark world
                    continue
                if exit.connected_region not in seen:
                    seen.add(exit.connected_region)
                    queue.append(exit.connected_region)


location_table = {'Mushroom': (0x180013, 0x186338, False, 'in the woods'),
                  'Bottle Merchant': (0x2eb18, 0x186339, False, 'with a merchant'),
                  'Flute Spot': (0x18014a, 0x18633d, False, 'underground'),
                  'Sunken Treasure': (0x180145, 0x186354, False, 'underwater'),
                  'Purple Chest': (0x33d68, 0x186359, False, 'from a box'),
                  "Blind's Hideout - Top": (0xeb0f, 0x1862e3, False, 'in a basement'),
                  "Blind's Hideout - Left": (0xeb12, 0x1862e6, False, 'in a basement'),
                  "Blind's Hideout - Right": (0xeb15, 0x1862e9, False, 'in a basement'),
                  "Blind's Hideout - Far Left": (0xeb18, 0x1862ec, False, 'in a basement'),
                  "Blind's Hideout - Far Right": (0xeb1b, 0x1862ef, False, 'in a basement'),
                  "Link's Uncle": (0x2df45, 0x18635f, False, 'with your uncle'),
                  'Secret Passage': (0xe971, 0x186145, False, 'near your uncle'),
                  'King Zora': (0xee1c3, 0x186360, False, 'at a high price'),
                  "Zora's Ledge": (0x180149, 0x186358, False, 'near Zora'),
                  'Waterfall Fairy - Left': (0xe9b0, 0x186184, False, 'near a fairy'),
                  'Waterfall Fairy - Right': (0xe9d1, 0x1861a5, False, 'near a fairy'),
                  "King's Tomb": (0xe97a, 0x18614e, False, 'alone in a cave'),
                  'Floodgate Chest': (0xe98c, 0x186160, False, 'in the dam'),
                  "Link's House": (0xe9bc, 0x186190, False, 'in your home'),
                  'Kakariko Tavern': (0xe9ce, 0x1861a2, False, 'in the bar'),
                  'Chicken House': (0xe9e9, 0x1861bd, False, 'near poultry'),
                  "Aginah's Cave": (0xe9f2, 0x1861c6, False, 'with Aginah'),
                  "Sahasrahla's Hut - Left": (0xea82, 0x186256, False, 'near the elder'),
                  "Sahasrahla's Hut - Middle": (0xea85, 0x186259, False, 'near the elder'),
                  "Sahasrahla's Hut - Right": (0xea88, 0x18625c, False, 'near the elder'),
                  'Sahasrahla': (0x2f1fc, 0x186365, False, 'with the elder'),
                  'Kakariko Well - Top': (0xea8e, 0x186262, False, 'in a well'),
                  'Kakariko Well - Left': (0xea91, 0x186265, False, 'in a well'),
                  'Kakariko Well - Middle': (0xea94, 0x186268, False, 'in a well'),
                  'Kakariko Well - Right': (0xea97, 0x18626b, False, 'in a well'),
                  'Kakariko Well - Bottom': (0xea9a, 0x18626e, False, 'in a well'),
                  'Blacksmith': (0x18002a, 0x186366, False, 'with the smith'),
                  'Magic Bat': (0x180015, 0x18635e, False, 'with the bat'),
                  'Sick Kid': (0x339cf, 0x186367, False, 'with the sick'),
                  'Hobo': (0x33e7d, 0x186368, False, 'with the hobo'),
                  'Lost Woods Hideout': (0x180000, 0x186348, False, 'near a thief'),
                  'Lumberjack Tree': (0x180001, 0x186349, False, 'in a hole'),
                  'Cave 45': (0x180003, 0x18634b, False, 'alone in a cave'),
                  'Graveyard Cave': (0x180004, 0x18634c, False, 'alone in a cave'),
                  'Checkerboard Cave': (0x180005, 0x18634d, False, 'alone in a cave'),
                  'Mini Moldorm Cave - Far Left': (0xeb42, 0x186316, False, 'near Moldorms'),
                  'Mini Moldorm Cave - Left': (0xeb45, 0x186319, False, 'near Moldorms'),
                  'Mini Moldorm Cave - Right': (0xeb48, 0x18631c, False, 'near Moldorms'),
                  'Mini Moldorm Cave - Far Right': (0xeb4b, 0x18631f, False, 'near Moldorms'),
                  'Mini Moldorm Cave - Generous Guy': (0x180010, 0x18635a, False, 'near Moldorms'),
                  'Ice Rod Cave': (0xeb4e, 0x186322, False, 'in a frozen cave'),
                  'Bonk Rock Cave': (0xeb3f, 0x186313, False, 'alone in a cave'),
                  'Library': (0x180012, 0x18635c, False, 'near books'),
                  'Potion Shop': (0x180014, 0x18635d, False, 'near potions'),
                  'Lake Hylia Island': (0x180144, 0x186353, False, 'on an island'),
                  'Maze Race': (0x180142, 0x186351, False, 'at the race'),
                  'Desert Ledge': (0x180143, 0x186352, False, 'in the desert'),
                  'Desert Palace - Big Chest': (0xe98f, 0x186163, False, 'in Desert Palace'),
                  'Desert Palace - Torch': (0x180160, 0x186362, False, 'in Desert Palace'),
                  'Desert Palace - Map Chest': (0xe9b6, 0x18618a, False, 'in Desert Palace'),
                  'Desert Palace - Compass Chest': (0xe9cb, 0x18619f, False, 'in Desert Palace'),
                  'Desert Palace - Big Key Chest': (0xe9c2, 0x186196, False, 'in Desert Palace'),
                  'Desert Palace - Boss': (0x180151, 0x18633f, False, 'with Lanmolas'),
                  'Eastern Palace - Compass Chest': (0xe977, 0x18614b, False, 'in Eastern Palace'),
                  'Eastern Palace - Big Chest': (0xe97d, 0x186151, False, 'in Eastern Palace'),
                  'Eastern Palace - Cannonball Chest': (0xe9b3, 0x186187, False, 'in Eastern Palace'),
                  'Eastern Palace - Big Key Chest': (0xe9b9, 0x18618d, False, 'in Eastern Palace'),
                  'Eastern Palace - Map Chest': (0xe9f5, 0x1861c9, False, 'in Eastern Palace'),
                  'Eastern Palace - Boss': (0x180150, 0x18633e, False, 'with the Armos'),
                  'Master Sword Pedestal': (0x289b0, 0x186369, False, 'at the pedestal'),
                  'Hyrule Castle - Boomerang Chest': (0xe974, 0x186148, False, 'in Hyrule Castle'),
                  'Hyrule Castle - Map Chest': (0xeb0c, 0x1862e0, False, 'in Hyrule Castle'),
                  "Hyrule Castle - Zelda's Chest": (0xeb09, 0x1862dd, False, 'in Hyrule Castle'),
                  'Sewers - Dark Cross': (0xe96e, 0x186142, False, 'in the sewers'),
                  'Sewers - Secret Room - Left': (0xeb5d, 0x186331, False, 'in the sewers'),
                  'Sewers - Secret Room - Middle': (0xeb60, 0x186334, False, 'in the sewers'),
                  'Sewers - Secret Room - Right': (0xeb63, 0x186337, False, 'in the sewers'),
                  'Sanctuary': (0xea79, 0x18624d, False, 'in Sanctuary'),
                  'Castle Tower - Room 03': (0xeab5, 0x186289, False, 'in Castle Tower'),
                  'Castle Tower - Dark Maze': (0xeab2, 0x186286, False, 'in Castle Tower'),
                  'Old Man': (0xf69fa, 0x186364, False, 'with the old man'),
                  'Spectacle Rock Cave': (0x180002, 0x18634a, False, 'alone in a cave'),
                  'Paradox Cave Lower - Far Left': (0xeb2a, 0x1862fe, False, 'in a cave with seven chests'),
                  'Paradox Cave Lower - Left': (0xeb2d, 0x186301, False, 'in a cave with seven chests'),
                  'Paradox Cave Lower - Right': (0xeb30, 0x186304, False, 'in a cave with seven chests'),
                  'Paradox Cave Lower - Far Right': (0xeb33, 0x186307, False, 'in a cave with seven chests'),
                  'Paradox Cave Lower - Middle': (0xeb36, 0x18630a, False, 'in a cave with seven chests'),
                  'Paradox Cave Upper - Left': (0xeb39, 0x18630d, False, 'in a cave with seven chests'),
                  'Paradox Cave Upper - Right': (0xeb3c, 0x186310, False, 'in a cave with seven chests'),
                  'Spiral Cave': (0xe9bf, 0x186193, False, 'in spiral cave'),
                  'Ether Tablet': (0x180016, 0x18633b, False, 'at a monolith'),
                  'Spectacle Rock': (0x180140, 0x18634f, False, 'atop a rock'),
                  'Tower of Hera - Basement Cage': (0x180162, 0x18633a, False, 'in Tower of Hera'),
                  'Tower of Hera - Map Chest': (0xe9ad, 0x186181, False, 'in Tower of Hera'),
                  'Tower of Hera - Big Key Chest': (0xe9e6, 0x1861ba, False, 'in Tower of Hera'),
                  'Tower of Hera - Compass Chest': (0xe9fb, 0x1861cf, False, 'in Tower of Hera'),
                  'Tower of Hera - Big Chest': (0xe9f8, 0x1861cc, False, 'in Tower of Hera'),
                  'Tower of Hera - Boss': (0x180152, 0x186340, False, 'with Moldorm'),
                  'Pyramid': (0x180147, 0x186356, False, 'on the pyramid'),
                  'Catfish': (0xee185, 0x186361, False, 'with a catfish'),
                  'Stumpy': (0x330c7, 0x18636a, False, 'with tree boy'),
                  'Digging Game': (0x180148, 0x186357, False, 'underground'),
                  'Bombos Tablet': (0x180017, 0x18633c, False, 'at a monolith'),
                  'Hype Cave - Top': (0xeb1e, 0x1862f2, False, 'near a bat-like man'),
                  'Hype Cave - Middle Right': (0xeb21, 0x1862f5, False, 'near a bat-like man'),
                  'Hype Cave - Middle Left': (0xeb24, 0x1862f8, False, 'near a bat-like man'),
                  'Hype Cave - Bottom': (0xeb27, 0x1862fb, False, 'near a bat-like man'),
                  'Hype Cave - Generous Guy': (0x180011, 0x18635b, False, 'with a bat-like man'),
                  'Peg Cave': (0x180006, 0x18634e, False, 'alone in a cave'),
                  'Pyramid Fairy - Left': (0xe980, 0x186154, False, 'near a fairy'),
                  'Pyramid Fairy - Right': (0xe983, 0x186157, False, 'near a fairy'),
                  'Brewery': (0xe9ec, 0x1861c0, False, 'alone in a home'),
                  'C-Shaped House': (0xe9ef, 0x1861c3, False, 'alone in a home'),
                  'Chest Game': (0xeda8, 0x18636b, False, 'as a prize'),
                  'Bumper Cave Ledge': (0x180146, 0x186355, False, 'on a ledge'),
                  'Mire Shed - Left': (0xea73, 0x186247, False, 'near sparks'),
                  'Mire Shed - Right': (0xea76, 0x18624a, False, 'near sparks'),
                  'Superbunny Cave - Top': (0xea7c, 0x186250, False, 'in a connection'),
                  'Superbunny Cave - Bottom': (0xea7f, 0x186253, False, 'in a connection'),
                  'Spike Cave': (0xea8b, 0x18625f, False, 'beyond spikes'),
                  'Hookshot Cave - Top Right': (0xeb51, 0x186325, False, 'across pits'),
                  'Hookshot Cave - Top Left': (0xeb54, 0x186328, False, 'across pits'),
                  'Hookshot Cave - Bottom Right': (0xeb5a, 0x18632e, False, 'across pits'),
                  'Hookshot Cave - Bottom Left': (0xeb57, 0x18632b, False, 'across pits'),
                  'Floating Island': (0x180141, 0x186350, False, 'on an island'),
                  'Mimic Cave': (0xe9c5, 0x186199, False, 'in a cave of mimicry'),
                  'Swamp Palace - Entrance': (0xea9d, 0x186271, False, 'in Swamp Palace'),
                  'Swamp Palace - Map Chest': (0xe986, 0x18615a, False, 'in Swamp Palace'),
                  'Swamp Palace - Big Chest': (0xe989, 0x18615d, False, 'in Swamp Palace'),
                  'Swamp Palace - Compass Chest': (0xeaa0, 0x186274, False, 'in Swamp Palace'),
                  'Swamp Palace - Big Key Chest': (0xeaa6, 0x18627a, False, 'in Swamp Palace'),
                  'Swamp Palace - West Chest': (0xeaa3, 0x186277, False, 'in Swamp Palace'),
                  'Swamp Palace - Flooded Room - Left': (0xeaa9, 0x18627d, False, 'in Swamp Palace'),
                  'Swamp Palace - Flooded Room - Right': (0xeaac, 0x186280, False, 'in Swamp Palace'),
                  'Swamp Palace - Waterfall Room': (0xeaaf, 0x186283, False, 'in Swamp Palace'),
                  'Swamp Palace - Boss': (0x180154, 0x186342, False, 'with Arrghus'),
                  "Thieves' Town - Big Key Chest": (0xea04, 0x1861d8, False, "in Thieves' Town"),
                  "Thieves' Town - Map Chest": (0xea01, 0x1861d5, False, "in Thieves' Town"),
                  "Thieves' Town - Compass Chest": (0xea07, 0x1861db, False, "in Thieves' Town"),
                  "Thieves' Town - Ambush Chest": (0xea0a, 0x1861de, False, "in Thieves' Town"),
                  "Thieves' Town - Attic": (0xea0d, 0x1861e1, False, "in Thieves' Town"),
                  "Thieves' Town - Big Chest": (0xea10, 0x1861e4, False, "in Thieves' Town"),
                  "Thieves' Town - Blind's Cell": (0xea13, 0x1861e7, False, "in Thieves' Town"),
                  "Thieves' Town - Boss": (0x180156, 0x186344, False, 'with Blind'),
                  'Skull Woods - Compass Chest': (0xe992, 0x186166, False, 'in Skull Woods'),
                  'Skull Woods - Map Chest': (0xe99b, 0x18616f, False, 'in Skull Woods'),
                  'Skull Woods - Big Chest': (0xe998, 0x18616c, False, 'in Skull Woods'),
                  'Skull Woods - Pot Prison': (0xe9a1, 0x186175, False, 'in Skull Woods'),
                  'Skull Woods - Pinball Room': (0xe9c8, 0x18619c, False, 'in Skull Woods'),
                  'Skull Woods - Big Key Chest': (0xe99e, 0x186172, False, 'in Skull Woods'),
                  'Skull Woods - Bridge Room': (0xe9fe, 0x1861d2, False, 'near Mothula'),
                  'Skull Woods - Boss': (0x180155, 0x186343, False, 'with Mothula'),
                  'Ice Palace - Compass Chest': (0xe9d4, 0x1861a8, False, 'in Ice Palace'),
                  'Ice Palace - Freezor Chest': (0xe995, 0x186169, False, 'in Ice Palace'),
                  'Ice Palace - Big Chest': (0xe9aa, 0x18617e, False, 'in Ice Palace'),
                  'Ice Palace - Iced T Room': (0xe9e3, 0x1861b7, False, 'in Ice Palace'),
                  'Ice Palace - Spike Room': (0xe9e0, 0x1861b4, False, 'in Ice Palace'),
                  'Ice Palace - Big Key Chest': (0xe9a4, 0x186178, False, 'in Ice Palace'),
                  'Ice Palace - Map Chest': (0xe9dd, 0x1861b1, False, 'in Ice Palace'),
                  'Ice Palace - Boss': (0x180157, 0x186345, False, 'with Kholdstare'),
                  'Misery Mire - Big Chest': (0xea67, 0x18623b, False, 'in Misery Mire'),
                  'Misery Mire - Map Chest': (0xea6a, 0x18623e, False, 'in Misery Mire'),
                  'Misery Mire - Main Lobby': (0xea5e, 0x186232, False, 'in Misery Mire'),
                  'Misery Mire - Bridge Chest': (0xea61, 0x186235, False, 'in Misery Mire'),
                  'Misery Mire - Spike Chest': (0xe9da, 0x1861ae, False, 'in Misery Mire'),
                  'Misery Mire - Compass Chest': (0xea64, 0x186238, False, 'in Misery Mire'),
                  'Misery Mire - Big Key Chest': (0xea6d, 0x186241, False, 'in Misery Mire'),
                  'Misery Mire - Boss': (0x180158, 0x186346, False, 'with Vitreous'),
                  'Turtle Rock - Compass Chest': (0xea22, 0x1861f6, False, 'in Turtle Rock'),
                  'Turtle Rock - Roller Room - Left': (0xea1c, 0x1861f0, False, 'in Turtle Rock'),
                  'Turtle Rock - Roller Room - Right': (0xea1f, 0x1861f3, False, 'in Turtle Rock'),
                  'Turtle Rock - Chain Chomps': (0xea16, 0x1861ea, False, 'in Turtle Rock'),
                  'Turtle Rock - Big Key Chest': (0xea25, 0x1861f9, False, 'in Turtle Rock'),
                  'Turtle Rock - Big Chest': (0xea19, 0x1861ed, False, 'in Turtle Rock'),
                  'Turtle Rock - Crystaroller Room': (0xea34, 0x186208, False, 'in Turtle Rock'),
                  'Turtle Rock - Eye Bridge - Bottom Left': (0xea31, 0x186205, False, 'in Turtle Rock'),
                  'Turtle Rock - Eye Bridge - Bottom Right': (0xea2e, 0x186202, False, 'in Turtle Rock'),
                  'Turtle Rock - Eye Bridge - Top Left': (0xea2b, 0x1861ff, False, 'in Turtle Rock'),
                  'Turtle Rock - Eye Bridge - Top Right': (0xea28, 0x1861fc, False, 'in Turtle Rock'),
                  'Turtle Rock - Boss': (0x180159, 0x186347, False, 'with Trinexx'),
                  'Palace of Darkness - Shooter Room': (0xea5b, 0x18622f, False, 'in Palace of Darkness'),
                  'Palace of Darkness - The Arena - Bridge': (0xea3d, 0x186211, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Stalfos Basement': (0xea49, 0x18621d, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Big Key Chest': (0xea37, 0x18620b, False, 'in Palace of Darkness'),
                  'Palace of Darkness - The Arena - Ledge': (0xea3a, 0x18620e, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Map Chest': (0xea52, 0x186226, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Compass Chest': (0xea43, 0x186217, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Dark Basement - Left': (0xea4c, 0x186220, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Dark Basement - Right': (0xea4f, 0x186223, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Dark Maze - Top': (0xea55, 0x186229, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Dark Maze - Bottom': (0xea58, 0x18622c, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Big Chest': (0xea40, 0x186214, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Harmless Hellway': (0xea46, 0x18621a, False, 'in Palace of Darkness'),
                  'Palace of Darkness - Boss': (0x180153, 0x186341, False, 'with Helmasaur King'),
                  "Ganons Tower - Bob's Torch": (0x180161, 0x186363, False, "in Ganon's Tower"),
                  'Ganons Tower - Hope Room - Left': (0xead9, 0x1862ad, False, "in Ganon's Tower"),
                  'Ganons Tower - Hope Room - Right': (0xeadc, 0x1862b0, False, "in Ganon's Tower"),
                  'Ganons Tower - Tile Room': (0xeae2, 0x1862b6, False, "in Ganon's Tower"),
                  'Ganons Tower - Compass Room - Top Left': (0xeae5, 0x1862b9, False, "in Ganon's Tower"),
                  'Ganons Tower - Compass Room - Top Right': (0xeae8, 0x1862bc, False, "in Ganon's Tower"),
                  'Ganons Tower - Compass Room - Bottom Left': (0xeaeb, 0x1862bf, False, "in Ganon's Tower"),
                  'Ganons Tower - Compass Room - Bottom Right': (0xeaee, 0x1862c2, False, "in Ganon's Tower"),
                  'Ganons Tower - DMs Room - Top Left': (0xeab8, 0x18628c, False, "in Ganon's Tower"),
                  'Ganons Tower - DMs Room - Top Right': (0xeabb, 0x18628f, False, "in Ganon's Tower"),
                  'Ganons Tower - DMs Room - Bottom Left': (0xeabe, 0x186292, False, "in Ganon's Tower"),
                  'Ganons Tower - DMs Room - Bottom Right': (0xeac1, 0x186295, False, "in Ganon's Tower"),
                  'Ganons Tower - Map Chest': (0xead3, 0x1862a7, False, "in Ganon's Tower"),
                  'Ganons Tower - Firesnake Room': (0xead0, 0x1862a4, False, "in Ganon's Tower"),
                  'Ganons Tower - Randomizer Room - Top Left': (0xeac4, 0x186298, False, "in Ganon's Tower"),
                  'Ganons Tower - Randomizer Room - Top Right': (0xeac7, 0x18629b, False, "in Ganon's Tower"),
                  'Ganons Tower - Randomizer Room - Bottom Left': (0xeaca, 0x18629e, False, "in Ganon's Tower"),
                  'Ganons Tower - Randomizer Room - Bottom Right': (0xeacd, 0x1862a1, False, "in Ganon's Tower"),
                  "Ganons Tower - Bob's Chest": (0xeadf, 0x1862b3, False, "in Ganon's Tower"),
                  'Ganons Tower - Big Chest': (0xead6, 0x1862aa, False, "in Ganon's Tower"),
                  'Ganons Tower - Big Key Room - Left': (0xeaf4, 0x1862c8, False, "in Ganon's Tower"),
                  'Ganons Tower - Big Key Room - Right': (0xeaf7, 0x1862cb, False, "in Ganon's Tower"),
                  'Ganons Tower - Big Key Chest': (0xeaf1, 0x1862c5, False, "in Ganon's Tower"),
                  'Ganons Tower - Mini Helmasaur Room - Left': (0xeafd, 0x1862d1, False, "atop Ganon's Tower"),
                  'Ganons Tower - Mini Helmasaur Room - Right': (0xeb00, 0x1862d4, False, "atop Ganon's Tower"),
                  'Ganons Tower - Pre-Moldorm Chest': (0xeb03, 0x1862d7, False, "atop Ganon's Tower"),
                  'Ganons Tower - Validation Chest': (0xeb06, 0x1862da, False, "atop Ganon's Tower"),
                  'Ganon': (None, None, False, 'from me'),
                  'Agahnim 1': (None, None, False, 'from Ganon\'s wizardry form'),
                  'Agahnim 2': (None, None, False, 'from Ganon\'s wizardry form'),
                  'Floodgate': (None, None, False, None),
                  'Frog': (None, None, False, None),
                  'Missing Smith': (None, None, False, None),
                  'Dark Blacksmith Ruins': (None, None, False, None),
                  'Eastern Palace - Prize': ([0x1209D, 0x53EF8, 0x53EF9, 0x180052, 0x18007C, 0xC6FE], None, True, 'Eastern Palace'),
                  'Desert Palace - Prize': ([0x1209E, 0x53F1C, 0x53F1D, 0x180053, 0x180078, 0xC6FF], None, True, 'Desert Palace'),
                  'Tower of Hera - Prize': ([0x120A5, 0x53F0A, 0x53F0B, 0x18005A, 0x18007A, 0xC706], None, True, 'Tower of Hera'),
                  'Palace of Darkness - Prize': ([0x120A1, 0x53F00, 0x53F01, 0x180056, 0x18007D, 0xC702], None, True, 'Palace of Darkness'),
                  'Swamp Palace - Prize': ([0x120A0, 0x53F6C, 0x53F6D, 0x180055, 0x180071, 0xC701], None, True, 'Swamp Palace'),
                  'Thieves\' Town - Prize': ([0x120A6, 0x53F36, 0x53F37, 0x18005B, 0x180077, 0xC707], None, True, 'Thieves\' Town'),
                  'Skull Woods - Prize': ([0x120A3, 0x53F12, 0x53F13, 0x180058, 0x18007B, 0xC704], None, True, 'Skull Woods'),
                  'Ice Palace - Prize': ([0x120A4, 0x53F5A, 0x53F5B, 0x180059, 0x180073, 0xC705], None, True, 'Ice Palace'),
                  'Misery Mire - Prize': ([0x120A2, 0x53F48, 0x53F49, 0x180057, 0x180075, 0xC703], None, True, 'Misery Mire'),
                  'Turtle Rock - Prize': ([0x120A7, 0x53F24, 0x53F25, 0x18005C, 0x180079, 0xC708], None, True, 'Turtle Rock'),
                  'Kakariko Shop - Left': (None, None, False, 'for sale in Kakariko'),
                  'Kakariko Shop - Middle': (None, None, False, 'for sale in Kakariko'),
                  'Kakariko Shop - Right': (None, None, False, 'for sale in Kakariko'),
                  'Lake Hylia Shop - Left': (None, None, False, 'for sale near the lake'),
                  'Lake Hylia Shop - Middle': (None, None, False, 'for sale near the lake'),
                  'Lake Hylia Shop - Right': (None, None, False, 'for sale near the lake'),
                  'Paradox Shop - Left': (None, None, False, 'for sale near seven chests'),
                  'Paradox Shop - Middle': (None, None, False, 'for sale near seven chests'),
                  'Paradox Shop - Right': (None, None, False, 'for sale near seven chests'),
                  'Capacity Upgrade - Left': (None, None, False, 'for sale near the queen'),
                  'Capacity Upgrade - Right': (None, None, False, 'for sale near the queen'),
                  'Village of Outcasts Shop - Left': (None, None, False, 'for sale near outcasts'),
                  'Village of Outcasts Shop - Middle': (None, None, False, 'for sale near outcasts'),
                  'Village of Outcasts Shop - Right': (None, None, False, 'for sale near outcasts'),
                  'Dark Lumberjack Shop - Left': (None, None, False, 'for sale in the far north'),
                  'Dark Lumberjack Shop - Middle': (None, None, False, 'for sale in the far north'),
                  'Dark Lumberjack Shop - Right': (None, None, False, 'for sale in the far north'),
                  'Dark Lake Hylia Shop - Left': (None, None, False, 'for sale near the dark lake'),
                  'Dark Lake Hylia Shop - Middle': (None, None, False, 'for sale near the dark lake'),
                  'Dark Lake Hylia Shop - Right': (None, None, False, 'for sale near the dark lake'),
                  'Dark Potion Shop - Left': (None, None, False, 'for sale near a catfish'),
                  'Dark Potion Shop - Middle': (None, None, False, 'for sale near a catfish'),
                  'Dark Potion Shop - Right': (None, None, False, 'for sale near a catfish'),
                  'Dark Death Mountain Shop - Left': (None, None, False, 'for sale on the dark mountain'),
                  'Dark Death Mountain Shop - Middle': (None, None, False, 'for sale on the dark mountain'),
                  'Dark Death Mountain Shop - Right': (None, None, False, 'for sale on the dark mountain'),
                  'Red Shield Shop - Left': (None, None, False, 'for sale as a curiosity'),
                  'Red Shield Shop - Middle': (None, None, False, 'for sale as a curiosity'),
                  'Red Shield Shop - Right': (None, None, False, 'for sale as a curiosity'),
                  'Potion Shop - Left': (None, None, False, 'for sale near the witch'),
                  'Potion Shop - Middle': (None, None, False, 'for sale near the witch'),
                  'Potion Shop - Right': (None, None, False, 'for sale near the witch'),
                  }
